<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\UserController;
use App\Http\Controllers\Api\IncidentReportController;
use App\Http\Controllers\Api\ProviderController;
use App\Http\Controllers\Api\AdminController;
use App\Http\Controllers\Api\ChiefController;
use App\Http\Controllers\Api\SubChiefController;
use App\Http\Controllers\Api\EmployeeController;
use App\Http\Controllers\Api\DepartmentController;
use App\Http\Controllers\Api\ProviderAvailabilityController;
use App\Http\Controllers\Api\AppointmentController;
use App\Http\Controllers\Api\PasswordController;

// Public Routes
Route::post('/login', [AuthController::class, 'login']);
Route::post('/forgot-password', [AuthController::class, 'forgotPassword']);
Route::post('/reset-password', [AuthController::class, 'resetPassword']);
Route::post('/validate-reset-token', [AuthController::class, 'validateResetToken']);

// Authenticated Routes
Route::middleware('auth:sanctum')->group(function () {
    Route::post('/logout', [AuthController::class, 'logout']);
    
    Route::get('/user', function (Request $request) {
        return $request->user()->load(['roles', 'admin', 'chief', 'subChief', 'employee', 'provider']);
    });

    // Password Management
    Route::post('/change-password', [PasswordController::class, 'changePassword']);
    Route::get('/password-status', [PasswordController::class, 'checkPasswordStatus']);

    // Incident Reporting
    Route::apiResource('incident-reports', IncidentReportController::class);
    
    // User Management (Generic)
    Route::apiResource('users', UserController::class);
    Route::apiResource('departments', DepartmentController::class);

    // Specific Role Management
    Route::apiResource('providers', ProviderController::class);
    Route::apiResource('admin', AdminController::class);
    Route::apiResource('chief', ChiefController::class); 
    Route::apiResource('sub-chief', SubChiefController::class);
    Route::apiResource('employees', EmployeeController::class);

    // Provider Availability
    Route::post('/provider-availability', [ProviderAvailabilityController::class, 'setAvailability']);
    Route::get('/provider-availability', [ProviderAvailabilityController::class, 'getAllProvidersAvailability']);
    Route::put('/provider-availability/{id}', [ProviderAvailabilityController::class, 'updateAvailability']);
    Route::delete('/provider-availability/{id}', [ProviderAvailabilityController::class, 'deleteAvailability']);
    Route::get('/check-availability', [ProviderAvailabilityController::class, 'checkAvailability']);
    Route::get('/provider-availability/{providerId}', [ProviderAvailabilityController::class, 'getAvailabilityById']);

    // Appointments
    Route::get('/employees/{id}/appointments', [AppointmentController::class, 'employee_appointment_details']);
    Route::get('/employees/{id}/appointments/summary', [AppointmentController::class, 'employee_appointment_summary']);
    Route::get('/providers/{id}/appointments', [AppointmentController::class, 'provider_appointment_details']);

    Route::get('appointments/{id}/join', [AppointmentController::class, 'join']);
    Route::apiResource('appointments', AppointmentController::class);
});
