<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Role;
use App\Models\Department;
use App\Models\Provider;
use App\Models\Admin;
use App\Models\Chief;
use App\Models\SubChief;
use App\Models\Employee;
use Illuminate\Support\Facades\Hash;
use App\Enum\UserRole;

class FullDummyDataSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Infrastructure
        $dummyDept = Department::firstOrCreate(
            ['name' => 'Dummy Department'],
            [
                'city' => 'Dummy City',
                'state' => 'CA',
                'contact_number' => '123-456-7890',
                'email' => 'dummy@dept.com',
                'address' => '123 Dummy St',
                'zip_code' => '90001'
            ]
        );

        // Get Roles
        $roles = [
            UserRole::Admin->value      => Role::where('name', UserRole::Admin->value)->first(),
            UserRole::Chief->value      => Role::where('name', UserRole::Chief->value)->first(),
            UserRole::SubChief->value   => Role::where('name', UserRole::SubChief->value)->first(),
            UserRole::Employee->value   => Role::where('name', UserRole::Employee->value)->first(),
            UserRole::Provider->value   => Role::where('name', UserRole::Provider->value)->first(),
        ];

        // 1. Fully filled ADMIN
        $adminUser = User::create([
            'name' => 'Dummy Admin',
            'username' => 'dummy_admin',
            'email' => 'dummy_admin@example.com',
            'password' => Hash::make('password'),
            'role' => UserRole::Admin->value,
            'phone' => '123-456-7890',
            'address' => '123 Admin Lane',
            'city' => 'Dummy City',
            'state' => 'CA',
            'zip_code' => '90001',
            'gender' => 'Other',
            'date_of_birth' => '1980-01-01',
            'is_active' => true,
            'profile_image' => 'https://via.placeholder.com/150',
            'department_id' => $dummyDept->id,
            'supervisor_id' => 0,
        ]);
        
        $adminProfile = Admin::create(['user_id' => $adminUser->id]);
        
        $adminUser->roles()->attach($roles[UserRole::Admin->value]->id, [
            'entity_id' => $adminProfile->id,
            'entity_type' => Admin::class,
            'entity_role' => 'Admin',
            'default_role' => true
        ]);

        // 2. Fully filled CHIEF
        $chiefUser = User::create([
            'name' => 'Dummy Chief',
            'username' => 'dummy_chief',
            'email' => 'dummy_chief@example.com',
            'password' => Hash::make('password'),
            'role' => UserRole::Chief->value,
            'phone' => '123-456-7891',
            'address' => '456 Chief Blvd',
            'city' => 'Dummy City',
            'state' => 'CA',
            'zip_code' => '90002',
            'gender' => 'Male',
            'date_of_birth' => '1975-05-15',
            'is_active' => true,
            'profile_image' => 'https://via.placeholder.com/150',
            'department_id' => $dummyDept->id,
            'supervisor_id' => 0,
        ]);

        $chiefProfile = Chief::create([
            'user_id' => $chiefUser->id,
            'badge_number' => 'DCH-001',
            'rank' => 'Chief of Police',
            'appointed_date' => '2015-06-01',
        ]);

        $chiefUser->roles()->attach($roles[UserRole::Chief->value]->id, [
            'entity_id' => $chiefProfile->id,
            'entity_type' => Chief::class,
            'entity_role' => 'Chief',
            'default_role' => true
        ]);

        // 3. Fully filled SUBCHIEF
        $subChiefUser = User::create([
            'name' => 'Dummy SubChief',
            'username' => 'dummy_subchief',
            'email' => 'dummy_subchief@example.com',
            'password' => Hash::make('password'),
            'role' => UserRole::SubChief->value,
            'phone' => '123-456-7892',
            'address' => '789 SubChief St',
            'city' => 'Dummy City',
            'state' => 'CA',
            'zip_code' => '90003',
            'gender' => 'Female',
            'date_of_birth' => '1985-08-20',
            'is_active' => true,
            'profile_image' => 'https://via.placeholder.com/150',
            'department_id' => $dummyDept->id,
            'supervisor_id' => $chiefUser->id,
        ]);

        $subChiefProfile = SubChief::create([
            'user_id' => $subChiefUser->id,
            'badge_number' => 'DSC-002',
            'rank' => 'Captain',
        ]);

        $subChiefUser->roles()->attach($roles[UserRole::SubChief->value]->id, [
            'entity_id' => $subChiefProfile->id,
            'entity_type' => SubChief::class,
            'entity_role' => 'SubChief',
            'default_role' => true
        ]);

        // 4. Fully filled EMPLOYEE
        $employeeUser = User::create([
            'name' => 'Dummy Employee',
            'username' => 'dummy_employee',
            'email' => 'dummy_employee@example.com',
            'password' => Hash::make('password'),
            'role' => UserRole::Employee->value,
            'phone' => '123-456-7893',
            'address' => '321 Officer Rd',
            'city' => 'Dummy City',
            'state' => 'CA',
            'zip_code' => '90004',
            'gender' => 'Male',
            'date_of_birth' => '1995-12-10',
            'is_active' => true,
            'profile_image' => 'https://via.placeholder.com/150',
            'department_id' => $dummyDept->id,
            'supervisor_id' => $subChiefUser->id,
        ]);

        $employeeProfile = Employee::create([
            'user_id' => $employeeUser->id,
            'badge_number' => 'EMP-100',
            'rank' => 'Sergeant',
            'position' => 'Patrol Supervisor',
            'hired_date' => '2018-03-15',
        ]);

        $employeeUser->roles()->attach($roles[UserRole::Employee->value]->id, [
            'entity_id' => $employeeProfile->id,
            'entity_type' => Employee::class,
            'entity_role' => 'Employee',
            'default_role' => true
        ]);

        // 5. Fully filled PROVIDER
        $providerUser = User::create([
            'name' => 'Dummy Provider',
            'username' => 'dummy_provider',
            'email' => 'dummy_provider@example.com',
            'password' => Hash::make('password'),
            'role' => UserRole::Provider->value,
            'phone' => '123-456-7894',
            'address' => '654 Doctor Drive',
            'city' => 'Dummy City',
            'state' => 'CA',
            'zip_code' => '90005',
            'gender' => 'Female',
            'date_of_birth' => '1982-04-05',
            'is_active' => true,
            'profile_image' => 'https://via.placeholder.com/150',
            'department_id' => $dummyDept->id,
            'supervisor_id' => 0,
        ]);

        $providerProfile = Provider::create([
            'user_id' => $providerUser->id,
            'npi' => '9876543210',
            'license_number' => 'MD-99999',
            'specialization' => 'Clinical Psychologist',
            'bio' => 'A dummy bio for the provider demonstrating the text field capability.',
        ]);

        $providerUser->roles()->attach($roles[UserRole::Provider->value]->id, [
            'entity_id' => $providerProfile->id,
            'entity_type' => Provider::class,
            'entity_role' => 'Provider',
            'default_role' => true
        ]);
    }
}
