<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Admin;
use App\Models\Role;
use Illuminate\Support\Facades\Hash;

class AdminSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Check if admin role exists
        $adminRole = Role::where('name', 'admin')->first();
        if (!$adminRole) {
            $this->command->info('Admin role not found. Please run RoleSeeder first.');
            return;
        }

        // Create Admin User
        $user = User::firstOrCreate(
            ['email' => 'admin@firstcall.com'],
            [
                'name' => 'Super Admin',
                'username' => 'superuser',
                'password' => Hash::make('password'), // Default password
            ]
        );

        // Assign Role
        // Check if user already has the role to prevent duplicate attempts if run multiple times
        if (!$user->roles()->where('name', 'admin')->exists()) {
             $user->roles()->attach($adminRole->id, ['entity_type' => Admin::class, 'entity_role' => 'Admin', 'default_role' => true]);
        }
       
        // Create Admin Profile
        if (!$user->admin) {
            Admin::create(['user_id' => $user->id]);
            // Now update the pivot with entity_id if needed, but we created it before obtaining ID.
            // Actually, usually we Create User -> Create Admin Profile -> Attach Role with pivot info.
            
            // Let's fix the pivot update
            $adminProfile = Admin::where('user_id', $user->id)->first();
            $user->roles()->updateExistingPivot($adminRole->id, ['entity_id' => $adminProfile->id]);
        } else {
             // ensure pivot is consistent
             $user->roles()->updateExistingPivot($adminRole->id, ['entity_id' => $user->admin->id]);
        }
    }
}
