<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('appointments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('employee_id')->constrained()->cascadeOnDelete();
            $table->foreignId('provider_id')->constrained()->cascadeOnDelete();
            
            $table->string('type')->default('telehealth'); // Default to telehealth (Doxy.me)
            
            // Core Date/Time fields
            $table->date('appointment_date');
            $table->time('start_time');
            $table->time('end_time');
            
            // Financials / Coding
            $table->string('cpt_code')->nullable();
            $table->decimal('fees', 10, 2)->nullable();
            
            // Status & Meta
            $table->string('status')->default('scheduled');
            $table->string('title')->nullable();
            $table->text('description')->nullable();
            
            // UI Helpers
            $table->string('color_primary')->nullable();
            $table->string('color_secondary')->nullable();
            $table->boolean('all_day')->default(false);
            $table->boolean('resizable_before_start')->default(false);
            $table->boolean('resizable_after_end')->default(false);
            $table->boolean('draggable')->default(false);

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('appointments');
    }
};
