<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('provider_availability_slots', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('provider_availability_id');
            $table->string('day_of_week');
            $table->time('start_time');
            $table->time('end_time');
            $table->date('date')->nullable();
            $table->timestamps();

            $table->foreign('provider_availability_id')->references('id')->on('provider_availabilities')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('provider_availability_slots');
    }
};
