<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // 1. Create Departments Table
        Schema::create('departments', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('city')->nullable();
            $table->string('state')->nullable();
            $table->string('contact_number')->nullable();
            $table->string('email')->nullable();
            $table->text('address')->nullable();
            $table->string('zip_code')->nullable();
            $table->string('website')->nullable();
            $table->text('description')->nullable();
            $table->timestamps();
        });

        // 2. Update Users Table
        Schema::table('users', function (Blueprint $table) {
            $table->foreignId('department_id')->nullable()->constrained()->onDelete('set null');
            $table->unsignedBigInteger('supervisor_id')->default(0)->after('department_id');
            
            // Add index for hierarchy lookups
            $table->index('supervisor_id');
        });

        // 3. Drop foreign keys and obsolete columns from role-specific tables
        Schema::table('providers', function (Blueprint $table) {
            $table->dropForeign(['practice_id']);
            $table->dropColumn('practice_id');
        });

        Schema::table('chiefs', function (Blueprint $table) {
            $table->dropForeign(['practice_id']);
            $table->dropColumn('practice_id');
        });

        Schema::table('sub_chiefs', function (Blueprint $table) {
            $table->dropForeign(['practice_id']);
            $table->dropForeign(['division_id']);
            $table->dropColumn(['practice_id', 'division_id']);
        });

        Schema::table('employees', function (Blueprint $table) {
            $table->dropForeign(['practice_id']);
            $table->dropForeign(['sub_division_id']);
            $table->dropColumn(['practice_id', 'sub_division_id']);
        });

        // 4. Cleanup: Drop only the organizational structure tables
        \Illuminate\Support\Facades\DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        
        Schema::dropIfExists('sub_divisions');
        Schema::dropIfExists('divisions');
        Schema::dropIfExists('practices');
        Schema::dropIfExists('cities');

        \Illuminate\Support\Facades\DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropForeign(['department_id']);
            $table->dropColumn(['department_id', 'supervisor_id']);
        });

        Schema::dropIfExists('departments');
        
        // Note: We don't recreate the dropped tables here to keep down' migration simple,
        // but in a real-world scenario you might want to restore them if reversible.
    }
};
