<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('incident_reports', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade'); // Officer/Employee
            
            // FORM METADATA
            $table->string('form_type'); // 'injury' or 'exposure'
            $table->string('form_version')->default('v1.2');
            $table->string('status')->default('submitted'); // submitted, provider_review, completed
            
            // SECTION 1: TELEHEALTH ACKNOWLEDGMENT
            $table->boolean('consent_telehealth')->default(false);

            // SECTION 2: OFFICER INFO (Snapshot at time of report or linked to User)
            $table->string('supervisor_name')->nullable();
            $table->string('supervisor_contact')->nullable();

            // SECTION 3: BPD DISTRICT / COMMAND ASSIGNMENT
            $table->string('district')->nullable(); // A-1, B-2, etc.

            // SECTION 4: INCIDENT DETAILS
            $table->date('incident_date');
            $table->time('incident_time');
            $table->string('location');
            
            // Injury Specific (JSON for multi-select)
            $table->json('injury_category')->nullable(); // Slip/Trip, Altercation, etc.
            
            // SECTION 5: MECHANISM OF INJURY
            $table->text('mechanism_description')->nullable();
            $table->json('mechanism_tags')->nullable(); // Twisting, Impact, etc.

            // SECTION 6: BODY PART(S)
            $table->json('body_parts')->nullable(); // Head, Neck, Shoulder(L), etc.

            // SECTION 7: SYMPTOMS
            $table->json('symptoms')->nullable(); // Pain, Swelling...

            // SECTION 8: RED FLAG SYMPTOMS
            // If "None of the above" is false, specific flags stored here
            $table->json('red_flags')->nullable();
            $table->boolean('has_red_flags')->default(false); // Quick lookup for routing

            // SECTION 9: FUNCTIONAL STATUS
            $table->unsignedTinyInteger('pain_score')->nullable(); // 0-10
            $table->string('work_status_intent')->nullable(); // Yes/No/Unsure
            $table->json('functional_limitations')->nullable();

            // SECTION 10: FIRST AID
            $table->json('first_aid_provided')->nullable();

            // SECTION 11: PRIOR RELATED INJURY
            $table->boolean('prior_injury_same_part')->default(false);
            $table->boolean('prior_injury_resolved')->default(true);

            // SECTION 12/11: PRIOR ED CARE
            $table->boolean('visited_ed')->default(false);
            $table->string('ed_facility')->nullable();
            $table->date('ed_visit_date')->nullable();
            $table->string('ed_outcome')->nullable();
            $table->json('ed_docs_available')->nullable();

            // --- EXPOSURE SPECIFIC FIELDS (Form 2) ---
            $table->string('exposure_type')->nullable(); // Needle stick, Splash...
            $table->json('exposure_category')->nullable(); // BBP, OPIM...
            $table->string('source_status')->nullable(); // Known/Unknown
            $table->string('source_type')->nullable(); // Human/Animal...
            $table->json('material_agent')->nullable(); // Blood, Saliva...
            $table->json('ppe_worn')->nullable();
            $table->boolean('decontamination_performed')->default(false);

            // SECTION 14/13: ATTESTATION
            $table->boolean('officer_attestation')->default(false); // Digital Signature equivalent
            $table->timestamp('attested_at')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('incident_reports');
    }
};
