<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Chiefs (likely Police Chief)
        Schema::table('chiefs', function (Blueprint $table) {
            $table->string('badge_number')->nullable();
            $table->string('rank')->nullable(); // e.g. "Chief of Police"
            $table->date('appointed_date')->nullable();
        });

        // SubChiefs (e.g. Lieutenants/Captains)
        Schema::table('sub_chiefs', function (Blueprint $table) {
            $table->string('badge_number')->nullable();
            $table->string('rank')->nullable(); // e.g. "Lieutenant"
        });

        // Employees (e.g. Officers)
        Schema::table('employees', function (Blueprint $table) {
            $table->string('badge_number')->nullable();
            $table->string('rank')->nullable(); // e.g. "Officer"
            $table->string('position')->nullable(); // e.g. "Patrol"
            $table->date('hired_date')->nullable();
        });

        // Providers (Medical)
        Schema::table('providers', function (Blueprint $table) {
            $table->string('npi')->nullable(); // National Provider Identifier
            $table->string('license_number')->nullable();
            $table->string('specialization')->nullable(); // e.g. "Psychologist"
            $table->text('bio')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('chiefs', function (Blueprint $table) {
            $table->dropColumn(['badge_number', 'rank', 'appointed_date']);
        });

        Schema::table('sub_chiefs', function (Blueprint $table) {
            $table->dropColumn(['badge_number', 'rank']);
        });

        Schema::table('employees', function (Blueprint $table) {
            $table->dropColumn(['badge_number', 'rank', 'position', 'hired_date']);
        });

        Schema::table('providers', function (Blueprint $table) {
            $table->dropColumn(['npi', 'license_number', 'specialization', 'bio']);
        });
    }
};
