<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_roles', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('role_id')->constrained()->onDelete('cascade');
            
            // Polymorphic relation to specific entity tables (chiefs, providers, etc)
            // nullable because a user might have a role but not yet an entity record, or role doesn't require one
            $table->unsignedBigInteger('entity_id')->nullable();
            $table->string('entity_type')->nullable(); // e.g. App\Models\Chief
            
            $table->string('entity_role')->nullable(); // e.g. "Chief" (friendly name, redundant but useful)
            $table->boolean('default_role')->default(false);
            $table->timestamps();

            $table->index(['entity_id', 'entity_type']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_roles');
    }
};
