<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // 1. Cities
        Schema::create('cities', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->timestamps();
        });

        // 2. Practices
        Schema::create('practices', function (Blueprint $table) {
            $table->id();
            $table->foreignId('city_id')->constrained()->onDelete('cascade');
            $table->string('name');
            $table->string('type')->default('police'); 
            $table->timestamps();
        });

        // 3. Divisions
        Schema::create('divisions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('practice_id')->constrained()->onDelete('cascade');
            // We will add chief_id constraint in a later migration to avoid circular dependency
            // or we assume it points to a User or a Chief entity. 
            // In pathways, it's usually the specialized Entity ID.
            $table->unsignedBigInteger('chief_id')->nullable(); 
            $table->string('name');
            $table->text('description')->nullable();
            $table->timestamps();
        });

        // 4. SubDivisions
        Schema::create('sub_divisions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('division_id')->constrained()->onDelete('cascade');
            $table->unsignedBigInteger('sub_chief_id')->nullable();
            $table->string('name');
            $table->timestamps();
        });
        
        // Removed modification of users table as we are using separate tables now.
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sub_divisions');
        Schema::dropIfExists('divisions');
        Schema::dropIfExists('practices');
        Schema::dropIfExists('cities');
    }
};
