<?php

namespace App\Services;

use App\Models\ProviderAvailability;
use App\Http\Resources\ProviderAvailabilityResource;
use Illuminate\Support\Facades\Auth;
use App\Models\Provider;

class AvailabilityService
{
    /**
     * Check availability for a provider.
     * If $providerId is null, it will use the authenticated user's provider ID.
     */
    public static function providerAvailabilitybyId($providerId = null)
    {
        try {
            // If no providerId passed, get it from authenticated user
            if (!$providerId) {
                $providerId = Provider::where('user_id', Auth::id())->value('id');
            }

            if (!$providerId) {
                return response()->json([
                    'success' => false,
                    'message' => 'Provider ID is required or user is not authenticated.',
                    'data' => []
                ], 401);
            }

            $availabilities = ProviderAvailability::where('provider_id', $providerId)
                ->with(['slots'])
                ->get();

            if ($availabilities->isEmpty() || $availabilities->every(fn($availability) => $availability->slots->isEmpty())) {
                return response()->json([
                    'success' => false,
                    'message' => 'This provider is not available.',
                    'data' => []
                ], 404);
            }

            return response()->json([
                'success' => true,
                'message' => 'Availabilities retrieved successfully.',
                'data' => ProviderAvailabilityResource::collection($availabilities)
            ], 200);

        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Failed to retrieve availabilities.',
                'data' => ['error' => $e->getMessage()]
            ], 500);
        }
    }
}
