<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class UserRole extends Model
{
    protected $table = 'user_roles';

    protected $fillable = [
        'user_id',
        'role_id',
        'entity_id',
        'entity_type',
        'entity_role',
        'default_role',
    ];

    protected $casts = [
        'default_role' => 'boolean',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function role()
    {
        return $this->belongsTo(Role::class);
    }

    public function entity()
    {
        return $this->morphTo();
    }
}
