<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProviderAvailability extends Model
{
    use HasFactory;

    protected $fillable = [
        'provider_id',
        'title',
        'day_of_week',
        'slots', // Kept for legacy if needed, but we use relation
        'type',
        'recurrence',
    ];
    
    protected $casts = [
        'day_of_week' => 'array',
    ];

    public function slots()
    {
        return $this->hasMany(ProviderAvailabilitySlot::class, 'provider_availability_id');
    }

    public function provider()
    {
        return $this->belongsTo(Provider::class);
    }

    // Location relationship commented out until Location model exists
    // public function locationFacility()
    // {
    //     return $this->belongsTo(Location::class, 'location_id');
    // }
}
