<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Provider extends Model
{
    /** @use HasFactory<\Database\Factories\ProviderFactory> */
    use HasFactory;

    protected $fillable = [
        'user_id', 
        'practice_id',
        'npi',
        'license_number',
        'specialization',
        'bio',
        'doxy_me_link'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function practice()
    {
        return $this->belongsTo(Practice::class);
    }

    public function availabilities()
    {
        return $this->hasMany(ProviderAvailability::class);
    }
}
