<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory; // Added this line

class IncidentReport extends Model
{
    use HasFactory;

    protected $guarded = ['id'];

    protected $casts = [
        'injury_category' => 'array',
        'mechanism_tags' => 'array',
        'body_parts' => 'array',
        'symptoms' => 'array',
        'red_flags' => 'array',
        'functional_limitations' => 'array',
        'first_aid_provided' => 'array',
        'ed_docs_available' => 'array',
        'exposure_category' => 'array',
        'material_agent' => 'array',
        'ppe_worn' => 'array',
        'incident_date' => 'date',
        'incident_time' => 'datetime:H:i', // or simply 'string' if formatting isn't strict
        'ed_visit_date' => 'date',
        'attested_at' => 'datetime',
        'has_red_flags' => 'boolean',
        'consent_telehealth' => 'boolean',
        'visited_ed' => 'boolean',
        'officer_attestation' => 'boolean',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
