<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProviderResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        if (is_null($this->resource)) {
            return [];
        }

        $user = $this->user;

        $data = [
            'id' => $this->id,
            'user_id' => $this->user_id,
            'practice_id' => $this->practice_id, // Provider specific
            
            'email' => optional($user)->email,
            'name' => optional($user)->name,
            'phone' => optional($user)->phone,
            'profile_image' => optional($user)->profile_image,
            'gender' => optional($user)->gender,
            'date_of_birth' => optional($user)->date_of_birth,
            'address' => optional($user)->address,
            'city' => optional($user)->city,
            'state' => optional($user)->state,
            'zip_code' => optional($user)->zip_code,
            'is_active' => (bool) optional($user)->is_active,
        ];

        // -----------------------------
        // Compute missing values
        // -----------------------------
        $missing = [];
        $requiredFields = [
            'name',
            'email',
            'phone',
            'practice_id', 
            // Add other mandatory fields
        ];

        foreach ($requiredFields as $field) {
            $value = $data[$field] ?? null;
            if (empty($value) && !is_numeric($value) && !is_bool($value)) {
                $missing[] = $field;
            }
        }

        $data['missing_values'] = $missing;

        return $data;
    }
}
