<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Services\ImageService;

class ProviderAvailabilityResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $imageService = new ImageService();
            
        return [
            'id' => $this->id,
            'provider_id' => $this->provider_id,
            'provider_name' => $this->provider?->user
                ? $this->provider->user->first_name . ' ' . $this->provider->user->last_name
                : null,
            'provider' => [
                'id' => optional($this->provider)->id,
                // 'specialties' => optional($this->provider)->specialties ? $this->provider->specialties->pluck('name')->toArray() : [], // Uncomment if specialties exist
            ],
            'profile_image' => $this->provider?->user ? $imageService->getImageDataUri($this->provider->user->profile_image) : null,
            'title' => $this->title,
            'type' => $this->type,
            'recurrence' => $this->recurrence,
            'slots' => ProviderAvailabilitySlotResource::collection($this->whenLoaded('slots')),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
