<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PatientResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        // NOTE: Adopting logic from pathways.
        // Assuming relationship 'user' exists on Patient model or this resource wraps Patient model directly.
        // If this resource is wrapping a USER model (as seen in some previous steps), we might need to adjust.
        // Based on pathways code provided, it seems to wrap a Patient model which has a user relation ($this->user).
        
        // Ensure we handle if $this is null (though uncommon in resources)
        if (is_null($this->resource)) {
            return [];
        }

        $user = $this->user; // Assuming belongsTo relationship logic

        $data = [
            'id' => $this->id,
            'user_id' => $this->user_id,
            // Basic User Fields
            'email' => optional($user)->email,
            'first_name' => optional($user)->name, // first_call seems to use 'name' instead of separate first/last often, but logic might vary
            'phone' => optional($user)->phone,
            'profile_image' => optional($user)->profile_image,
            'gender' => optional($user)->gender,
            'date_of_birth' => optional($user)->date_of_birth,
            'address' => optional($user)->address,
            'city' => optional($user)->city,
            'state' => optional($user)->state,
            'zip_code' => optional($user)->zip_code, // first_call uses zip_code
             // ... Add other specific fields ...
             
             // Dynamic completion check
             'is_active' => (bool) optional($user)->is_active,
        ];

        // -----------------------------
        // Compute missing values
        // -----------------------------
        $missing = [];
        $requiredFields = [
            'first_name',
            'email',
            'phone',
            'address',
            'city',
            'state',
            'zip_code',
            'gender',
            'date_of_birth',
        ];

        foreach ($requiredFields as $field) {
            $value = $data[$field] ?? null;
            if (empty($value) && !is_numeric($value) && !is_bool($value)) {
                $missing[] = $field;
            }
        }

        $data['missing_values'] = $missing;

        return $data;
    }
}
