<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Services\ImageService;

class AppointmentResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $imageService = new ImageService();
        
        return [
            'id' => $this->id,
            'title' => $this->title,
            'start' => $this->appointment_date . ' ' . $this->start_time,
            'end' => $this->appointment_date . ' ' . $this->end_time,
            'appointment_date' => $this->appointment_date,
            'start_time' => $this->start_time,
            'end_time' => $this->end_time,
            'status' => $this->status,
            'type' => $this->type,
            'fees' => $this->fees,
            'cpt_code' => $this->cpt_code,
            'description' => $this->description,
            'employee_id' => $this->employee_id,
            'employee_name' => $this->employee?->user ? $this->employee->user->name : 'Unknown',
            // 'mrn' => $this->patient?->mrn, // Removed MRN if not applicable or can be added if employee has one
            'provider_id' => $this->provider_id,
            'provider_name' => $this->provider?->user ? $this->provider->user->name : 'Unknown',
            'join_url' => url("/api/appointments/{$this->id}/join"),
            'color_primary' => $this->color_primary,
            'color_secondary' => $this->color_secondary,
            'all_day' => (bool)$this->all_day,
            'draggable' => (bool) $this->draggable,
            'resizable' => [
                'beforeStart' => (bool) $this->resizable_before_start,
                'afterEnd' => (bool) $this->resizable_after_end,
            ],
        ];
    }
}
