<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreProviderRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Prepare the data for validation.
     */
    protected function prepareForValidation()
    {
        if (empty($this->all()) && !empty($this->getContent())) {
            $data = json_decode($this->getContent(), true);
            if (is_array($data)) {
                $this->merge($data);
            }
        }
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        $id = $this->route('provider') ?? $this->route('id');

        $rules = [
            // User Basic Fields
            'name'          => 'required|string|max:255',
            'username'      => ['nullable', 'string', 'max:255', Rule::unique('users')->ignore($id)],
            'email'         => ['required', 'string', 'email', 'max:255', Rule::unique('users')->ignore($id)],
            'password'      => [$id ? 'nullable' : 'required', 'string', 'min:8'],
            'phone'         => 'nullable|string',
            'address'       => 'nullable|string',
            'city'          => 'nullable|string',
            'state'         => 'nullable|string',
            'zip_code'      => 'nullable|string',
            'gender'        => 'nullable|string',
            'date_of_birth' => 'nullable|date',
            'profile_image' => 'nullable|string', // Base64
            // Provider Specific Fields
            'department_id' => 'nullable|exists:departments,id',
            'supervisor_id' => 'nullable|integer',
            'npi'           => 'nullable|string|max:20',
            'license_number'=> 'nullable|string|max:50',
            'specialization'=> 'nullable|string|max:255',
            'bio'           => 'nullable|string',
            'doxy_me_link'  => [
                'nullable', 
                'url', 
                'max:255', 
                'regex:/^https:\/\/.*\.doxy\.me\/[a-zA-Z0-9\-_]+$/'
            ], // Secured validation
            'is_active'     => 'boolean',
            'active_role'   => 'nullable|string',
        ];

        if ($id) {
            $rules['name'] = 'sometimes|required|string|max:255';
            $rules['email'] = ['sometimes', 'required', 'string', 'email', 'max:255', Rule::unique('users')->ignore($id)];
        }

        return $rules;
    }
}
