<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreChiefRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    protected function prepareForValidation()
    {
        if (empty($this->all()) && !empty($this->getContent())) {
            $data = json_decode($this->getContent(), true);
            if (is_array($data)) {
                $this->merge($data);
            }
        }
    }

    public function rules(): array
    {
        $id = $this->route('chief') ?? $this->route('id');

        $rules = [
            'name'          => 'required|string|max:255',
            'username'      => ['nullable', 'string', 'max:255', Rule::unique('users')->ignore($id)],
            'email'         => ['required', 'string', 'email', 'max:255', Rule::unique('users')->ignore($id)],
            'password'      => [$id ? 'nullable' : 'required', 'string', 'min:8'],
            'phone'         => 'nullable|string',
            'address'       => 'nullable|string',
            'city'          => 'nullable|string',
            'state'         => 'nullable|string',
            'zip_code'      => 'nullable|string',
            'gender'        => 'nullable|string',
            'date_of_birth' => 'nullable|date',
            'profile_image' => 'nullable|string',
            'department_id' => 'nullable|exists:departments,id',
            'supervisor_id' => 'nullable|integer',
            'badge_number'  => 'nullable|string|max:50',
            'rank'          => 'nullable|string|max:100',
            'appointed_date'=> 'nullable|date',
            'is_active'     => 'boolean',
            'active_role'   => 'nullable|string',
        ];

        if ($id) {
            $rules['name'] = 'sometimes|required|string|max:255';
            $rules['email'] = ['sometimes', 'required', 'string', 'email', 'max:255', Rule::unique('users')->ignore($id)];
        }

        return $rules;
    }
}
