<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckActiveRole
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = $request->user();

        // If no user is authenticated, we can't check roles. Let auth middleware handle it or proceed.
        if (!$user) {
            return $next($request);
        }

        // Get the requested active role from query params or body
        $activeRole = $request->input('active_role') ?? $request->query('active_role');

        // If active_role is not specified, you might default to primaryRole or just proceed.
        // If strict checking is required whenever active_role is present:
        if ($activeRole) {
            // Ensure the user actually has this role assigned
            // Assuming $user->hasRole($role) exists on the User model
            if (!method_exists($user, 'hasRole') || !$user->hasRole($activeRole)) {
                 return response()->json([
                    'code' => '403',
                    'message' => "You do not have access to the '{$activeRole}' role view."
                ], 403);
            }
        }

        return $next($request);
    }
}
