<?php

namespace App\Http\Controllers;

abstract class Controller
{
    protected function sendResponse($result, $message, $page = null, $total = null, $perPage = null, $totalPage = null, $metaKey = 'total', $extraMeta = [])
    {
        $response = [
            'success' => true,
            'data'    => $result,
            'message' => $message,
        ];

        if ($page !== null && $total !== null && $perPage !== null) {
            $response['meta'] = array_merge([
                $metaKey => $total,
                'per_page' => $perPage,
                'current_page' => $page,
                'total_pages' => $totalPage,
            ], $extraMeta); // ← merge summary here
        }

        return response()->json($response, 200);
    }


    // return error response
    public function sendError($error, $errorMessages = [], $code = 404)
    {
        $response = [
            'success' => false,
            'message' => $error,
        ];

        if (!empty($errorMessages)) {
            $response['data'] = $errorMessages;
        }

        return response()->json($response, $code);
    }
}
