<?php

namespace App\Enum;

use App\Models\Admin;
use App\Models\Chief;
use App\Models\SubChief;
use App\Models\Provider;
use App\Models\Employee;

enum UserRole: string
{
    case Admin      = 'admin';
    case Chief      = 'chief';
    case SubChief   = 'subchief';
    case Provider   = 'provider';
    case Employee   = 'employee';

    public function modelClass(): ?string
    {
        return match($this) {
            self::Admin     => Admin::class,
            self::Chief     => Chief::class,
            self::SubChief  => SubChief::class,
            self::Provider  => Provider::class,
            self::Employee  => Employee::class,
        };
    }
}
